document.addEventListener("DOMContentLoaded", function () {
    const sections = document.querySelectorAll(".section, .schedule-section, .kegiatan-section");
    const hamburger = document.getElementById("hamburger-menu");
    const sidebar = document.getElementById("sidebar");
    const closeSidebar = document.getElementById("close-sidebar");
    const overlay = document.getElementById("overlay");
    const submenuParents = document.querySelectorAll(".has-submenu");
    const navbar = document.querySelector(".navbar");

    // 📌 Active Menu Link On Scroll
    window.addEventListener("scroll", () => {
        let current = "";
        sections.forEach((section) => {
            const sectionTop = section.offsetTop;
            if (window.scrollY >= sectionTop - 30) {
                current = section.getAttribute("id") || "";
            }
        });
        document.querySelectorAll(".nav-links li a").forEach((link) => {
            link.classList.remove("active");
            if (link.getAttribute("href").slice(1) === current) {
                link.classList.add("active");
            }
        });
        if (window.scrollY > 50) {
            navbar.classList.add("visible");
        } else {
            navbar.classList.remove("visible");
        }
    });


    // Dropdown Menu
    const dropdownParents = document.querySelectorAll(".has-dropdown");
    dropdownParents.forEach(parent => {
        const dropdownMenu = parent.querySelector(".dropdown-menu");
        const dropdownLink = parent.querySelector("a");

        // Toggle dropdown on click 
        dropdownLink.addEventListener("click", (e) => {
            // Only toggle if on desktop (min-width: 769px)
            if (window.innerWidth >= 769) {
                e.preventDefault(); // Prevent navigation on click
                e.stopPropagation();

                // Close other dropdowns
                dropdownParents.forEach(p => {
                    if (p !== parent) {
                        p.classList.remove("active");
                    }
                });

                // Toggle the current dropdown
                parent.classList.toggle("active");
            }
        });

        // Close dropdown when clicking a dropdown item
        dropdownMenu.querySelectorAll("a").forEach(link => {
            link.addEventListener("click", (e) => {
                e.stopPropagation(); // Prevent bubbling up to parent
                parent.classList.remove("active"); // Close the dropdown after clicking an item
            });
        });
    });

    // Close all dropdowns when clicking outside
    document.addEventListener("click", (e) => {
        if (!e.target.closest(".has-dropdown")) {
            dropdownParents.forEach(parent => {
                parent.classList.remove("active");
            });
        }
    });


    // Open/Close Sidebar
    hamburger.addEventListener("click", function () {
        sidebar.classList.add("active");
        overlay.classList.add("active");
    });
    overlay.addEventListener("click", function () {
        sidebar.classList.remove("active");
        overlay.classList.remove("active");
        submenuParents.forEach(parent => parent.classList.remove("active"));
    });
    closeSidebar.addEventListener("click", function () {
        sidebar.classList.remove("active");
        overlay.classList.remove("active");
        submenuParents.forEach(parent => parent.classList.remove("active"));
    });
    submenuParents.forEach(parent => {
        parent.addEventListener("click", function (e) {
            e.preventDefault();
            e.stopPropagation();
            submenuParents.forEach(p => { if (p !== parent) p.classList.remove("active"); });
            this.classList.toggle("active");
        });
    });

    // Handle Submenu Toggle
    submenuParents.forEach(parent => {
        const menuTitle = parent.querySelector(".menu-title");
        const submenuIcon = parent.querySelector(".submenu-icon");
        const submenu = parent.querySelector(".submenu");
        const submenuLinks = submenu.querySelectorAll("li a"); 

        // Toggle submenu when clicking the menu title
        menuTitle.addEventListener("click", function (e) {
            e.preventDefault();
            e.stopPropagation();

            // Close other submenus
            submenuParents.forEach(p => {
                if (p !== parent) p.classList.remove("active");
            });

            // Toggle the current submenu
            parent.classList.toggle("active");
        });

        // Toggle submenu when clicking the arrow
        submenuIcon.addEventListener("click", function (e) {
            e.preventDefault();
            e.stopPropagation();

            // Close other submenus
            submenuParents.forEach(p => {
                if (p !== parent) p.classList.remove("active");
            });

            
            parent.classList.toggle("active");
        });

        // Prevent submenu clicks from bubbling up and toggling the parent
        submenu.addEventListener("click", function (e) {
            e.stopPropagation();
        });

        submenuLinks.forEach(link => {
            link.addEventListener("click", function (e) {
                e.stopPropagation();

                // Optionally, prevent default navigation for testing
                // e.preventDefault();
                // console.log("Submenu link clicked:", link.href);

                // If you want to close the sidebar after clicking a submenu link, you can add:
                // sidebar.classList.remove("active");
                // overlay.classList.remove("active");
                // submenuParents.forEach(p => p.classList.remove("active"));
            });
        });
    });

    // Section Snapping
    let isScrolling = false;
    let scrollTimeout;
    function getClosestSection() {
        let minDistance = Infinity;
        let closestSection = null;
        sections.forEach((section) => {
            const rect = section.getBoundingClientRect();
            const distance = Math.abs(rect.top);
            if (distance < 200 && distance < minDistance && rect.top >= 0) {
                minDistance = distance;
                closestSection = section;
            }
        });
        const footer = document.querySelector("footer");
        const footerRect = footer.getBoundingClientRect();
        if (footerRect.top <= window.innerHeight) return null;
        return closestSection;
    }
    function scrollToSection(section) {
        if (section && !isScrolling) {
            isScrolling = true;
            window.scrollTo({ top: section.offsetTop, behavior: "smooth" });
            setTimeout(() => { isScrolling = false; }, 500);
        }
    }
    function handleScroll() {
        if (!isScrolling) {
            clearTimeout(scrollTimeout);
            scrollTimeout = setTimeout(() => {
                const closestSection = getClosestSection();
                if (closestSection) scrollToSection(closestSection);
            }, 100);
        }
    }
    window.addEventListener("scroll", handleScroll);
    if (sections.length > 0) scrollToSection(sections[0]);


    // Toggle Login Modal
const loginIcon = document.getElementById('login-icon');
const loginModal = document.getElementById('login-modal');
const loginModalClose = document.getElementById('login-modal-close');
const cancelBtn = document.getElementById('cancel-btn');

loginIcon.addEventListener('click', () => {
    loginModal.classList.add('active');
});

loginModalClose.addEventListener('click', () => {
    loginModal.classList.remove('active');
});

cancelBtn.addEventListener('click', () => {
    loginModal.classList.remove('active');
});

loginModal.addEventListener('click', (e) => {
    if (e.target === loginModal) {
        loginModal.classList.remove('active');
    }
});

// Toggle Password Visibility
const passwordInput = document.getElementById('password');
const passwordToggle = document.getElementById('password-toggle');

passwordToggle.addEventListener('click', () => {
    if (passwordInput.type === 'password') {
        passwordInput.type = 'text';
        passwordToggle.classList.remove('fa-eye-slash');
        passwordToggle.classList.add('fa-eye');
    } else {
        passwordInput.type = 'password';
        passwordToggle.classList.remove('fa-eye');
        passwordToggle.classList.add('fa-eye-slash');
    }
});



    // Schedule Section Data and Generation
    const scheduleContent = document.getElementById("scheduleContent");
    const scheduleData = [
        {
            className: "prapaskah-1",
            background: "img/bgjadwal1.png",
            title: "Misa Harian",
            description: "",
            times: [
                { day: "Senin-Kamis", time: "05:30 WIB" },
                { day: "Jumat", time: "17:30 WIB" }
            ]
        },
        {
            className: "prapaskah-2",
            background: "img/bgjadwal2.png",
            title: "Misa Mingguan",
            description: "Minggu, 23 Maret 2025",
            times: [
                { day: "Sabtu", time: "17:00 WIB" },
                { day: "Minggu", times: ["07:00 WIB", "17:00 WIB"] }
            ]
        },
        {
            className: "prapaskah-3",
            background: "img/bgjadwal4.jpg",
            title: "Jalan Salib",
            description: "Jumat, 21 Maret 2025",
            times: [{ day: "Jumat", time: "17:00 WIB" }]
        }
    ];

    function generateScheduleContent(data = []) {
        scheduleContent.innerHTML = "";
        data.forEach(item => {
            const card = document.createElement("div");
            card.className = `schedule-card ${item.className}`;
            card.style.backgroundImage = `url('${item.background}')`;
            let timesHtml = item.times.map(t => {
                const times = Array.isArray(t.times) ? t.times.map(time => `<button class="time-button">${time}</button>`).join("") : `<button class="time-button">${t.time}</button>`;
                return `<div class="time-block"><span class="day-label">${t.day}</span>${times}</div>`;
            }).join("");
            card.innerHTML = `
                <div class="schedule-content">
                    <h2>${item.title}</h2>
                    <p>${item.description}</p>
                </div>
                <div class="schedule-times">${timesHtml}</div>
            `;
            scheduleContent.appendChild(card);
        });
    }
    
// Berita Section
const beritaCarousel = document.getElementById("beritaCarousel");
const beritaDots = document.getElementById("beritaDots");
let beritaCurrentIndex = 0;
let itemsPerSlide = getItemsPerSlide();
let autoScrollInterval;

// Helper function 
function getItemsPerSlide() {
    if (window.innerWidth <= 768) return 1;
    if (window.innerWidth <= 1024) return 2;
    return 3;
}

// Helper function to truncate text
function truncateText(text, maxLength) {
    if (text.length <= maxLength) return text;
    return text.substring(0, maxLength) + "...";
}

// Data for Berita section
let agendaData = [
    { 
        id: 1, 
        image: "img/img3.jpg", 
        title: "Visitasi dan Misa Bersama Uskup", 
        description: "Sabtu, 1 Maret 2025. Pukul: 17.00 WIB", 
        fullDescription: "", 
        buttonText: "Baca Pengumuman" 
    },
    { 
        id: 2, 
        image: "img/img4.jpg", 
        title: "Misa Rabu Abu", 
        description: "Rabu, 5 Maret. Pukul: 05.30 WIB dan Pukul: 17.30 WIB", 
        fullDescription: "", 
        buttonText: "Baca Pengumuman" 
    },
    { 
        id: 3, 
        image: "img/im5.jpg", 
        title: "Warta Pastoral Paroki", 
        description: "", 
        fullDescription: "", 
        buttonText: "Baca Pengumuman" 
    },
    { 
        id: 4, 
        image: "img/img6.jpg", 
        title: "Warta Pastoral Paroki Yesus Dipersembahkan Ke Bait Allah", 
        description: "Tes page...", 
        fullDescription: "", 
        buttonText: "Baca Pengumuman" 
    },
    { 
        id: 5, 
        image: "img/img7.jpg", 
        title: "", 
        description: "Tes page...", 
        fullDescription: "", 
        buttonText: "Baca Pengumuman" 
    }
];

// Generate Berita cards
function generateBeritaCards(data = []) {
    beritaCarousel.innerHTML = "";
    if (data.length === 0) {
        const card = document.createElement("div");
        card.className = "berita-card placeholder";
        card.innerHTML = `<div class="berita-content"><h3>Tidak Ada Agenda</h3></div>`;
        beritaCarousel.appendChild(card);
    } else {
        data.forEach((item, index) => {
            const truncatedTitle = truncateText(item.title, 30); // Truncate 30 characters
            const truncatedDesc = truncateText(item.description, 50); // Truncate 50 characters
            const card = document.createElement("div");
            card.className = "berita-card";
            card.dataset.index = index; 
            card.innerHTML = `
                <img src="${item.image}" alt="${item.title}">
                <div class="berita-content">
                    <h3>${truncatedTitle}</h3>
                    <p>${truncatedDesc}</p>
                    <button class="berita-button">${item.buttonText}</button>
                </div>
            `;
            beritaCarousel.appendChild(card);
        });
    }
    initializeBeritaCarousel();
    setupBeritaModal(); 
}

// Initialize the Berita carousel
function initializeBeritaCarousel() {
    const beritaCards = document.querySelectorAll(".berita-card");
    itemsPerSlide = getItemsPerSlide();
    let totalSlides = Math.ceil(beritaCards.length / itemsPerSlide);
    beritaDots.innerHTML = "";
    for (let i = 0; i < totalSlides; i++) {
        const dot = document.createElement("div");
        dot.className = "carousel-dot";
        if (i === 0) dot.classList.add("active");
        dot.addEventListener("click", () => moveBeritaCarousel(i));
        beritaDots.appendChild(dot);
    }
    beritaCurrentIndex = 0;
    moveBeritaCarousel(0);
}

// Move the Berita carousel to a specific slide
function moveBeritaCarousel(index) {
    beritaCurrentIndex = index;
    const wrapper = document.querySelector(".berita-carousel-wrapper");
    const wrapperWidth = wrapper.offsetWidth;
    const offset = -index * wrapperWidth;
    beritaCarousel.style.transform = `translateX(${offset}px)`;
    document.querySelectorAll(".carousel-dot").forEach((dot, i) => {
        dot.classList.toggle("active", i === index);
    });
}

// Move to the next Berita slide
function nextBeritaSlide() {
    const beritaCards = document.querySelectorAll(".berita-card");
    const totalSlides = Math.ceil(beritaCards.length / itemsPerSlide);
    beritaCurrentIndex = (beritaCurrentIndex + 1) % totalSlides;
    moveBeritaCarousel(beritaCurrentIndex);
}

// Move to the previous Berita slide
function prevBeritaSlide() {
    const beritaCards = document.querySelectorAll(".berita-card");
    const totalSlides = Math.ceil(beritaCards.length / itemsPerSlide);
    beritaCurrentIndex = (beritaCurrentIndex - 1 + totalSlides) % totalSlides;
    moveBeritaCarousel(beritaCurrentIndex);
}

// Set up modal event listeners
function setupBeritaModal() {
    const modal = document.getElementById("berita-modal");
    const modalImage = modal.querySelector(".modal-image img");
    const modalTitle = modal.querySelector(".modal-title");
    const modalDate = modal.querySelector(".modal-date");
    const modalDesc = modal.querySelector(".modal-desc");
    const modalClose = modal.querySelector(".modal-close");

    // Add event listeners to berita buttons
    document.querySelectorAll(".berita-button").forEach(button => {
        button.addEventListener("click", (e) => {
            const beritaCard = e.target.closest(".berita-card");
            const index = beritaCard.dataset.index;
            const berita = agendaData[index];

            modalImage.src = berita.image;
            modalImage.alt = berita.title;
            modalTitle.textContent = berita.title;
            if (modalDate) modalDate.textContent = berita.description; 
            modalDesc.textContent = berita.fullDescription;

            // Show the modal and pause the carousel
            modal.classList.add("active");
            clearInterval(autoScrollInterval);
        });
    });

   
    modalClose.addEventListener("click", () => {
        modal.classList.remove("active");
        autoScrollInterval = setInterval(nextBeritaSlide, 4000); 
    });

    
    window.addEventListener("click", (e) => {
        if (e.target === modal) {
            modal.classList.remove("active");
            autoScrollInterval = setInterval(nextBeritaSlide, 4000); 
        }
    });

    // Close the modal with the Esc key
    window.addEventListener("keydown", (e) => {
        if (e.key === "Escape" && modal.classList.contains("active")) {
            modal.classList.remove("active");
            autoScrollInterval = setInterval(nextBeritaSlide, 4000); 
        }
    });
}


document.querySelector(".next-berita-btn").addEventListener("click", nextBeritaSlide);
document.querySelector(".prev-berita-btn").addEventListener("click", prevBeritaSlide);
autoScrollInterval = setInterval(nextBeritaSlide, 4000);

// window resize
window.addEventListener("resize", () => {
    itemsPerSlide = getItemsPerSlide();
    generateBeritaCards(agendaData);
    moveBeritaCarousel(beritaCurrentIndex);
});

//generate cards
generateBeritaCards(agendaData);


// Scroll Arrow 
const scrollArrow = document.getElementById("scroll-arrow");
const scrollArrowIcon = scrollArrow.querySelector("i");


const seksi = ["hero", "section-target", "berita", "kegiatan-section", "pengumuman", "footer"]; // Update with your actual section IDs

// top of the page
function isAtTop() {
    return window.scrollY < 50;
}

// bottom of the page
function isAtBottom() {
    return window.scrollY + window.innerHeight >= document.documentElement.scrollHeight - 50;
}

// arrow direction and visibility
function toggleArrowDirection() {
    if (isAtTop()) {
        scrollArrowIcon.classList.remove("fa-chevron-up");
        scrollArrowIcon.classList.add("fa-chevron-down");
        scrollArrow.classList.remove("hidden");
    } else if (isAtBottom()) {
        scrollArrowIcon.classList.remove("fa-chevron-down");
        scrollArrowIcon.classList.add("fa-chevron-up");
        scrollArrow.classList.add("hidden");
    } else {
        scrollArrowIcon.classList.remove("fa-chevron-down");
        scrollArrowIcon.classList.add("fa-chevron-up");
        scrollArrow.classList.remove("hidden");
    }
}

// Function next section to scroll to
function findNextSection() {
    const scrollPosition = window.scrollY + window.innerHeight / 2;
    console.log("Current scroll position:", scrollPosition); 
    for (let i = 0; i < seksi.length - 1; i++) {
        const currentSection = document.getElementById(seksi[i]);
        const nextSection = document.getElementById(seksi[i + 1]);
        if (!currentSection || !nextSection) {
            console.log(`Section not found: ${seksi[i]} or ${seksi[i + 1]}`); 
            continue;
        }
        const currentSectionTop = currentSection.offsetTop;
        const nextSectionTop = nextSection.offsetTop;
        console.log(`Section ${seksi[i]} top: ${currentSectionTop}, Section ${seksi[i + 1]} top: ${nextSectionTop}`); 

        if (scrollPosition >= currentSectionTop && scrollPosition < nextSectionTop) {
            console.log(`Next section found: ${seksi[i + 1]}`); 
            return nextSection;
        }
    }
    console.log("No next section found"); 
    return null;
}

// Function scroll to a specific element
function scrollToElement(element) {
    window.scrollTo({
        top: element.offsetTop,
        behavior: "smooth"
    });
}

// scroll to toggle arrow direction
window.addEventListener("scroll", () => {
    toggleArrowDirection();
});

// arrow click
scrollArrow.addEventListener("click", () => {
    console.log("Arrow clicked, direction:", scrollArrowIcon.classList.contains("fa-chevron-down") ? "down" : "up"); // Debug click
    console.log("Is at top:", isAtTop()); 
    if (isAtTop() || scrollArrowIcon.classList.contains("fa-chevron-down")) {
        // Scroll to the next section
        const nextSection = findNextSection();
        if (nextSection) {
            console.log("Scrolling to:", nextSection.id); 
            scrollToElement(nextSection);
        } else {
            console.log("No next section to scroll to"); 
        }
    } else {
        // Scroll to the top
        console.log("Scrolling to top"); 
        window.scrollTo({
            top: 0,
            behavior: "smooth"
        });
    }
});


toggleArrowDirection();


    // Kegiatan Section Data
    const kegiatanContent = document.getElementById("kegiatanContent");
    const kegiatanUpcomingContent = document.getElementById("kegiatanUpcomingContent");
    const kegiatanData = [
        { date: "9", month: "MARET", title: "Nama kegiatan 1", time: "17:00 WIB - 19:00 WIB", description: "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.", fullContent: "Nama kegiatan 1<br>09-03-2025 / Gereja Santa Maria Blitar / Lingkungan 1<br>Pernah menjalani masa Prapaskah dengan doa, puasa, dan sedekah untuk mempersiapkan hati menuju Paskah. Acara ini diadakan untuk seluruh umat paroki." },
        { date: "16", month: "MARET", title: "Nama kegiatan 2", time: "17:00 WIB - 19:00 WIB", description: "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.", fullContent: "Nama kegiatan 2<br>16-03-2025 / Gereja Santa Maria Blitar / Lingkungan 2<br>Pernah mengadakan rekoleksi spiritual untuk umat paroki, fokus pada refleksi pribadi selama masa Prapaskah." }
    ];
    const kegiatanUpcomingData = [
        { date: "23", month: "MARET", title: "Nama kegiatan 3", time: "17:00 WIB - 19:00 WIB", description: "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.", fullContent: "Nama kegiatan 3<br>23-03-2025 / Gereja Santa Maria Blitar / Lingkungan 3<br>Pernah mengadakan misa khusus untuk anak-anak dengan tema Prapaskah, diikuti oleh keluarga paroki." },
        { date: "30", month: "MARET", title: "Nama kegiatan 4", time: "17:00 WIB - 19:00 WIB", description: "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.", fullContent: "Nama kegiatan 4<br>30-03-2025 / Gereja Santa Maria Blitar / Lingkungan 4<br>Pernah mengadakan pengajaran Katekese untuk persiapan Paskah, dihadiri oleh stasi-stasi paroki." }
    ];

    function generateKegiatanContent(data = [], container) {
        container.innerHTML = "";
        data.forEach(item => {
            const card = document.createElement("div");
            card.className = "kegiatan-card";
            card.dataset.fullContent = item.fullContent;
            card.innerHTML = `
                <div class="date-box">${item.date}<br><span>${item.month}</span></div>
                <div class="kegiatan-content">
                    <h2>${item.title}</h2>
                    <p>${item.time}</p>
                    <p>${item.description}</p>
                </div>
            `;
            container.appendChild(card);
        });
    }

    // Pengumuman Section Data
    function generatePengumumanContent(data = []) {
        const pengumumanContent = document.getElementById("pengumumanContent");
        pengumumanContent.innerHTML = "";
        data.forEach(item => {
            // Generate snippet
            const snippet = item.fullContent.length > 100 
                ? item.fullContent.substring(0, 100) + "…" 
                : item.fullContent;
    
            const announcement = document.createElement("div");
            announcement.className = "announcement";
            announcement.innerHTML = `
                <div class="announcement-image" style="background-image: url('${item.image || ''}');"></div>
                <div class="announcement-content">
                    <h3 class="announcement-title">${item.title}</h3>
                    <p class="announcement-body">${snippet}</p>
                    <a href="template.html?page=artikel?id=${item.id}" class="read-more">Baca selengkapnya…</a>
                </div>
            `;
            pengumumanContent.appendChild(announcement);
        });
// scroll animation after content is added
const announcements = document.querySelectorAll(".announcement");
function revealOnScroll() {
    announcements.forEach((announcement, index) => {
        const rect = announcement.getBoundingClientRect();
        const windowHeight = window.innerHeight;
        if (rect.top < windowHeight * 0.85) {
            setTimeout(() => { announcement.classList.add("show"); }, index * 200);
        }
    });
}
window.addEventListener("scroll", revealOnScroll);
revealOnScroll();
}

    // Initialize Dynamic Content
    generateScheduleContent(scheduleData);
    generateBeritaCards(agendaData);
    generateKegiatanContent(kegiatanData, kegiatanContent);
    generateKegiatanContent(kegiatanUpcomingData, kegiatanUpcomingContent);
    generatePengumumanContent(pengumumanData);
});